
; Personal Alarm

;	ERRORLEVEL -302
;	ERRORLEVEL -306


	    list      p=12F617            ; list directive to define processor
     #include <p12F617.inc>        ; processor specific variable definitions


 __CONFIG   _CP_OFF & _BOR_OFF & _MCLRE_OFF & _WDT_ON & _PWRTE_ON &_INTRC_OSC_CLKOUT & _IOSCFS_8MHZ &_WRT_OFF

; Bank 0 RAM

SECONDS			equ	H'20'	; seconds counter
STORE1				equ	H'21'	; delay counter
STORE2				equ	H'22'	; delay counter
STORE3				equ	H'23'	; delay counter
COUNTER			equ	H'24'	; timer0 counter
BURST				equ	H'25'	; 4kHz piezo burst period
LED_ON_FLG		equ	H'26'	; LED on/off flag
LED_FLASH			equ	H'27'	; LED flash rate
REPEAT			equ	H'28' 	; Alarm tone burst repeat
WARBLE			equ	H'29'	; warbling flags

; all banks
STARTUP			equ	H'70'	; startup period without alarm
TEMP				equ	H'71'	; temporary
TRANS				equ	H'72'	; transducer running flag
	org	0
	goto	SETUP
	org	4	
	nop					; INTERRUPT vector ; (not used)

; ******************************************************************
	org	5
SETUP
; set inputs/outputs
	movlw	B'00000000'
	movwf	GPIO			; ports low
	movlw	B'00000111'		; comparators off
	movwf	CMCON0
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000000'		; pullups 
	movwf	WPU
	movlw	B'00001100'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	movlw	B'10101101'		; settings (pullups disabled) wdt prescaler/32 (18ms x 32 timeout) bit 5 allows T0CKI timer 0 counter
	movwf	OPTION_REG
	

; analog/ digital inputs
	movlw	B'00000000'		; all digital 
	movwf	ANSEL

	bcf		STATUS,RP0	; bank 0
;initialise
	clrf		LED_ON_FLG	; LED off
	movlw	D'69'
	movwf	STARTUP		; startup at faster rate and without alarm
	clrf		TRANS
	movlw	D'1'
	movwf	COUNTER		; timer overflow event counter

SHUTDOWN ; set up wdt for SLEEP ; low power mode
	clrf		GPIO			; outputs low
	btfsc	LED_ON_FLG,0	; check LED flag for on or off
	bsf		GPIO,5			; LED on
	clrwdt	 				; Clear WDT
	clrf	 	TMR0 			; Clear TMR0 and prescaler
	bsf		STATUS,RP0	; select memory bank 1

; GP2/T0CKI as a low output to prevent floating 1M ohm input
	movlw	B'00001000'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register

; use faster watchdog with startup period

;Watchdog divider
;000 /1
;001 /2
;010 /4
;011 /8	
;100 /16
;101 /32 
;110 /64
;111 /128

	movlw	B'00000101'		; prescaler /32 (576ms timeout) 	standard rate
; check startup
	movf	STARTUP,f
	btfss	STATUS,Z		; when zero, end of startup so use 576ms watchdog timeout
	movlw	B'00000011'		; prescaler /8 for faster rate at 144ms
	movwf	TEMP

; if drive use /8
	btfsc	TRANS,0
	movlw	B'00000100'
	movwf	TEMP
; transfer prescaler from timer0 to watchdog
	bsf		OPTION_REG,PSA ;Select WDT
	clrwdt					; Clear WDT
	movlw	B'11111000'		; Mask prescaler
	andwf	OPTION_REG,W ; bits
	iorwf	TEMP,w			; prescaler value	
	movwf	OPTION_REG 	; 

	clrwdt					; Clear WDT
	bcf		STATUS,RP0	; select memory bank 0

	sleep					; stop operations
	nop

; awakes with watchdog timeout
	clrwdt					; Clear WDT and prescaler
; reduce startup to 0
	movf	STARTUP,w
	btfss	STATUS,Z		; if not zero then reduce
	decf	STARTUP,f

	bsf		STATUS,RP0	; select memory bank 1

; GP2/T0CKI as an input
	movlw	B'00001100'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register

; change prescaler from watchdog to timer0 (can use 010 ls bits for /4 and 1.024ms timeout for T0IF on INTCON)
	movlw	B'11110000'		; mask
	andwf	OPTION_REG,w	; just prescaler bits
	iorlw	B'00000010'		; prescaler at /4
	movwf	OPTION_REG
	bcf		STATUS,RP0	; select memory bank 0
	clrf		TMR0

	bcf		INTCON,T0IF 

	incf		LED_FLASH,f
	btfss	LED_FLASH,0	; drive LED alternately
	bsf		GPIO,5			; LED on

; wait for > 512us to check if overrange. If so then signal coming through timer0
	movlw	D'3'
	movwf	STORE3
MORE
	call		DELAY1
	decfsz	STORE3
	goto	MORE

;check timer0 overflow  flag 

	btfss	INTCON,T0IF 
	goto	CK_CNTR
	bcf		LED_ON_FLG,0	; clear LED flag for off
	movlw	D'1'
	movwf	COUNTER		; timer overflow event counter
	clrf		TRANS			; transducer running
	goto	SHUTDOWN		; sleep

CK_CNTR	
; check counter
	bsf		GPIO,5			; LED on
	bsf		LED_ON_FLG,0	; set LED on	
	movf	COUNTER,w
	btfsc	STATUS,Z
	goto	DRIVE			; drive piezo when zero
	decf	COUNTER,f	
	
	goto	SHUTDOWN		; sleep

DRIVE	
; no drive if during startup
	movf	STARTUP,w
	btfss	STATUS,Z		; startup ended
	goto	SHUTDOWN

; drive piezo or siren
	btfss	GPIO,3			; check if piezo transducer or siren
	goto	TRANSDUCER

; siren
	bsf		GPIO,0			; drive siren with high level	
	
SIREN
	bcf		INTCON,T0IF 

; wait for > 512us to check if overrange. If so then signal coming through timer0
	movlw	D'3'
	movwf	STORE3
MORE_S
	call		DELAY1
	decfsz	STORE3
	goto	MORE_S

; check for signal
	btfss	INTCON,T0IF 
	goto	SIREN
	bcf		LED_ON_FLG,0	; clear LED flag for off
	movlw	D'1'
	movwf	COUNTER		; timer overflow event counter
	goto	SHUTDOWN		; sleep

TRANSDUCER ; piezo transducer requires frequency drive
	bsf		TRANS,0		; set so drive in progress allows faster watchdog
	movlw	D'3'
	movwf	WARBLE		; for changing modulation
	movlw	D'20'
	movwf	REPEAT
BURST1
	movlw	D'50'			; burst
	movwf	STORE2			; individual burst length
	call		GENERATOR_S	; 4kHz tone (uses STORE1)
	movlw	D'10'			;  
	movwf	STORE3
OFF_DEL

; warble from 400Hz to 600Hz
	movf	WARBLE,w
	xorlw	D'13'	; start again at 13
	btfss	STATUS,Z
	goto	OK
	movlw	D'12'
	movwf	WARBLE

OK	movf	WARBLE,w
	incf		WARBLE,f	; next value
	call		DELW
	decfsz	STORE3,f
	goto	OFF_DEL
	decfsz	REPEAT,f
	goto 	BURST1

	goto	SHUTDOWN		; sleep

;4kHz generator (set STORE2 before routine for burst length)	
GENERATOR_S

; set GP1 and GP4 to outputs
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00001000'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	bcf		STATUS,RP0	; select memory bank 0

GENERATOR_RUN

movlw	B'00000010'		; bit 1 set bit 0 clear
	movwf	GPIO
	clrwdt
	movlw	D'80'			; frequency value 
	movwf	STORE1
DEC1_S
	decfsz	STORE1,f
	goto	DEC1_S
	movlw	B'00000001'		; bit 0 set bit 1 clear
	movwf	GPIO
	clrwdt
	movlw	D'80'			;  frequency value
	movwf	STORE1
DEC2_S
	decfsz	STORE1,f
	goto	DEC2_S
	decfsz	STORE2,f		; 4kHz burst length
	goto	GENERATOR_RUN
	return

DELW
	movwf	STORE1		; STORE1 is number of loops value
LOOP12Z
	movlw	D'1'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP13_W
	clrwdt
	decfsz	STORE2,f
	goto	LOOP13_W
	decfsz	STORE1,f
	goto	LOOP12Z
	return

DELAY1;  delay
	movlw	D'200'			; about 1.16ms loop
DELAY2
	movwf	STORE1
LOOP1
	clrwdt					; keep watchdog timer cleared
	movlw	D'2'				
	movwf	STORE2
LOOP2
	decfsz	STORE2,f
	goto	LOOP2
	nop

	decfsz	STORE1,f
	goto	LOOP1
	return

	end